var aiosp_use = false;
var aiosp_use_event;
var aiosp_countdown;
var aiosp_timeout;
var aiosp_redirect_url;
var aiosp_scroll_lock = false;
var aiosp_idle_counter = 0;
var aiosp_idle_timeout;
var aiosp_lock = false;
var aiosp_disable_close = false;
var aiosp_value_cookie;
var aiosp_value_load_delay;
var aiosp_value_load_start_delay;
var aiosp_value_load_once_per_visit;
var aiosp_value_load_disable_close;
var aiosp_value_exit_delay;
var aiosp_value_exit_excluded;
var aiosp_value_copy_block;
var aiosp_value_idle_delay;
var aiosp_value_scroll_once_per_visit;
var aiosp_value_scroll_offset;
var aiosp_value_load_enable;
var aiosp_value_exit_enable;
var aiosp_value_copy_enable;
var aiosp_value_idle_enable;
var aiosp_value_scroll_enable;
var aiosp_value_context_enable;
var aiosp_value_disable_name;
var aiosp_value_disable_mobile;
var aiosp_value_width;
var aiosp_value_height;
var aiosp_value_overlay_bg_color;
var aiosp_value_overlay_opacity;
var aiosp_value_popup_bg_url;
var aiosp_value_popup_bg_color;
var aiosp_initialized = false;

var aiosp_baseurl = (function() {
	var re = new RegExp('js/aiosp-jsonp(\.min)?\.js.*'),
	scripts = document.getElementsByTagName('script');
	for (var i = 0, ii = scripts.length; i < ii; i++) {
		var path = scripts[i].getAttribute('src');
		if(re.test(path)) return path.replace(re, '');
	}
})();

jQuery(document).ready(function() {
	aiosp_init();
});

function aiosp_init() {
	if (aiosp_initialized) return;
	aiosp_initialized = true;
	var aiosp_action = aiosp_baseurl + "ajax.php";
	jQuery.ajax({
		url: aiosp_action, 
		data: {
			action: "aiosp_getbox"
		},
		dataType: "jsonp",
		success: function(data) {
			var html_data = data.html;
			if(html_data.match("aiosp_container") != null) {
				aiosp_value_cookie = data.cookie;
				aiosp_value_load_delay = parseInt(data.load_delay);
				aiosp_value_load_start_delay = 1000*parseInt(data.load_start_delay);
				aiosp_value_load_once_per_visit = data.load_once_per_visit;
				aiosp_value_load_disable_close = data.load_disable_close;
				aiosp_value_exit_delay = parseInt(data.exit_delay);
				var tmp = data.exit_excluded;
				aiosp_value_exit_excluded = tmp.split(",");
				aiosp_value_copy_block = data.copy_block;
				aiosp_value_idle_delay = parseInt(data.idle_delay);
				aiosp_value_scroll_once_per_visit = data.scroll_once_per_visit;
				aiosp_value_scroll_offset = parseInt(data.scroll_offset);
				aiosp_value_load_enable = data.load_enable;
				aiosp_value_exit_enable = data.exit_enable;
				aiosp_value_copy_enable = data.copy_enable;
				aiosp_value_idle_enable = data.idle_enable;
				aiosp_value_scroll_enable = data.scroll_enable;
				aiosp_value_context_enable = data.context_enable;
				aiosp_value_disable_name = data.disable_name;
				aiosp_value_disable_mobile = data.disable_mobile;
				aiosp_value_width = parseInt(data.width);
				aiosp_value_height = parseInt(data.height);
				aiosp_value_overlay_bg_color = data.overlay_bg_color;
				aiosp_value_overlay_opacity = parseFloat(data.overlay_opacity);
				aiosp_value_popup_bg_url = data.popup_bg_url;
				aiosp_value_popup_bg_color = data.popup_bg_color;
				jQuery('body').append(html_data);
				aiosp_start();
			}
		}
	});
}

function aiosp_open() {
	try {
		if (!aiosp_use) {
			aiosp_use = true;
			jQuery("#aiosp_name").removeClass("aiosp_redborder");
			jQuery("#aiosp_email").removeClass("aiosp_redborder");

			var aiosp_overlay_style = "style='background: "+aiosp_value_overlay_bg_color+"; opacity: "+aiosp_value_overlay_opacity+"; -ms-filter:\"progid:DXImageTransform.Microsoft.Alpha(Opacity="+parseInt(100*aiosp_value_overlay_opacity)+")\"; filter:alpha(opacity=\""+parseInt(100*aiosp_value_overlay_opacity)+"\";'";
			jQuery("body").append("<div id='aiosp_overlay' "+aiosp_overlay_style+"></div><div id='aiosp_window' style='position: fixed; background:"+aiosp_value_popup_bg_color+" url("+aiosp_value_popup_bg_url+") 0 0 repeat;'></div>");
			
			var aiosp_width = aiosp_value_width + 30;
			var aiosp_height = aiosp_value_height + 40;

			var aiosp_close_button = "";
			if (!aiosp_disable_close) {
				jQuery("#aiosp_overlay").click(aiosp_close);
				aiosp_close_button = '<span id="aiosp_close" onclick="aiosp_close();">×</span>';
			}
			
			var window_width = jQuery(window).width();
			if (window_width > 0 && window_width < aiosp_width+30) {
				aiosp_width = window_width - 30;
			}
			
			jQuery("#aiosp_window").append("<div id='aiosp_content' style='width:"+parseInt(aiosp_width-30, 10)+"px; min-height:"+parseInt(aiosp_height-45, 10)+"px;'></div>"+aiosp_close_button+"<span id='aiosp_delay'></span>");

			jQuery("#aiosp_content").append(jQuery("#aiosp_container").children());
			jQuery("#aiosp_window").bind('aiosp_unload', function () {
				jQuery("#aiosp_container").append(jQuery("#aiosp_content").children() );
			});
			var content_height = jQuery("#aiosp_content").height();
			if (content_height > aiosp_height-45) {
				aiosp_height = content_height + 30;
			}

			var window_height = jQuery(window).height();
			if (window_height > 0 && window_height < aiosp_height+30) {
				aiosp_height = window_height - 30;
			}
			
			jQuery("#aiosp_window").css({
				"margin-left": '-'+parseInt((aiosp_width / 2),10)+'px', 
				"width": aiosp_width+'px',
				"margin-top": parseInt((window_height / 2),10)+'px',
				"height": aiosp_height+'px'
			});
			jQuery("#aiosp_overlay").fadeIn(300, function() {
				jQuery("#aiosp_window").css({
					"visibility" : "visible"
				});
				jQuery("#aiosp_window").animate({
					"margin-top": '-'+parseInt((aiosp_height / 2),10)+'px',
				}, 300);
			});
		}
	} catch(e) {

	}
	return false;
}

function aiosp_close() {
	aiosp_use = false;
	aiosp_disable_close = false;
	clearTimeout(aiosp_timeout);
	if (aiosp_use_event == "exit" && aiosp_countdown == 0) {
		window.location.href = aiosp_redirect_url;
	} else if (aiosp_use_event == "idle") {
		aiosp_idle_counter = 0;
		aiosp_idle_timeout = setTimeout("aiosp_idle_counter_handler();", 1000);	
	}
	jQuery("#aiosp_delay").html("");
	jQuery("#aiosp_overlay").fadeOut(500, function() {
		jQuery("#aiosp_overlay").trigger("aiosp_unload").unbind().remove();
	});
	jQuery("#aiosp_window").fadeOut(500, function() {
		jQuery("#aiosp_window").trigger("aiosp_unload").unbind().remove();
	});
	return false;
}

function aiosp_read_cookie(key) {
	var pairs = document.cookie.split("; ");
	for (var i = 0, pair; pair = pairs[i] && pairs[i].split("="); i++) {
		if (pair[0] === key) return pair[1] || "";
	}
	return null;
}

function aiosp_write_cookie(key, value, days) {
	if (days) {
		var date = new Date();
		date.setTime(date.getTime()+(days*24*60*60*1000));
		var expires = "; expires="+date.toGMTString();
	} else var expires = "";
	document.cookie = key+"="+value+expires+"; path=/";
}

function aiosp_countdown_string(value) {
	var result = '';
	var hours = Math.floor(value/3600);
	var minutes = Math.floor((value - 3600*hours)/60);
	var seconds = value - 3600*hours - 60*minutes;
	if (hours > 0) {
		if (hours > 9) result = hours.toString() + ":";
		else result = "0" + hours.toString() + ":";
	}
	if (minutes > 9) result = result + minutes.toString() + ":";
	else result = result + "0" + minutes.toString() + ":";
	if (seconds > 9) result = result + seconds.toString();
	else result = result + "0" + seconds.toString();
	return result;
}

function aiosp_start() {
	var aiosp_cookie = aiosp_read_cookie("aiosp");
	if (aiosp_cookie != aiosp_value_cookie) {
		var window_width = jQuery(window).width();
		if (aiosp_value_disable_mobile != "on" || window_width <= 0 || window_width >= aiosp_value_width+30+30) {
			aiosp_use = false;
			if (aiosp_value_load_enable == "on") {
				var aiosp_tmp = aiosp_read_cookie("aiosp_load");
				if (aiosp_tmp != aiosp_value_cookie) {
					if (aiosp_value_load_start_delay == 0) aiosp_init_open("load", aiosp_value_load_delay);
					else setTimeout(function() {aiosp_init_open("load", aiosp_value_load_delay);}, aiosp_value_load_start_delay);
				}
			}
			if (aiosp_value_exit_enable == "on") {
				jQuery("a").each(function() {
					var href = this.href;
					var domain = document.domain;
					if (href.match("[http|https]://") != null && href.match("[http|https]://"+document.domain) == null) {
						for (var i=0; i<aiosp_value_exit_excluded.length; i++) {
							if (href.match(aiosp_value_exit_excluded[i]) != null) {
								return;
							}
						}
						jQuery(this).click(function() {
							aiosp_redirect_url = this.href;
							return !aiosp_init_open("exit", aiosp_value_exit_delay);
						});
					}
				});
			}
			if (aiosp_value_scroll_enable == "on") {
				jQuery(window).scroll(function() {
					var position = jQuery(window).scrollTop();
					var aiosp_tmp = aiosp_read_cookie("aiosp_scroll");
					if (aiosp_tmp != aiosp_value_cookie) {
						if (!aiosp_use) {
							if (position >= aiosp_value_scroll_offset && !aiosp_scroll_lock) {
								aiosp_init_open("scroll", 0);
							}
						}
					}
				});
			}
			if (aiosp_value_copy_enable == "on") {
				jQuery(window).bind("copy", function(e) {
					if (aiosp_lock == false) {
						if (aiosp_value_copy_block == "on") e.preventDefault();
						aiosp_init_open("copy", 0);
						if (aiosp_value_copy_block == "on") return false;
						return true;
					} else return true;
				});
			}
			if (aiosp_value_context_enable == "on") {
				jQuery(window).bind("contextmenu", function(e) {
					if (aiosp_lock == false) {
						e.preventDefault();
						aiosp_init_open("context", 0);
						return false;
					} else return true;
				});
			}
			if (aiosp_value_idle_enable == "on") {
				jQuery(window).mousemove(function(event) {
					aiosp_idle_counter = 0;
				});
				jQuery(window).click(function(event) {
					aiosp_idle_counter = 0;
				});
				jQuery(window).keypress(function(event) {
					aiosp_idle_counter = 0;
				});
				jQuery(window).scroll(function(event) {
					aiosp_idle_counter = 0;
				});
				aiosp_idle_timeout = setTimeout("aiosp_idle_counter_handler();", 1000);
			}
		}
	}
	jQuery(".aiosp_click, .aiosp").click(function() {
		aiosp_open("click", 0);
		return false;
	});
	jQuery(".aiosp-go").click(function() {
		aiosp_redirect_url = this.href;
		var delay = parseInt(aiosp_value_exit_delay, 10);
		if (delay <= 0) delay = 20;
		return !aiosp_init_open("exit", aiosp_value_exit_delay);
	});
}

function aiosp_idle_counter_handler() {
	if (aiosp_idle_counter >= aiosp_value_idle_delay) {
		aiosp_init_open("idle", 0);
	} else {
		aiosp_idle_counter = aiosp_idle_counter + 1;
		aiosp_idle_timeout = setTimeout("aiosp_idle_counter_handler();", 1000);
	}
}

function aiosp_init_open(event, delay) {
	if (aiosp_use == false && aiosp_lock == false) {
		aiosp_use_event = event;
		aiosp_countdown = delay;
		if (event == "load" && aiosp_value_load_disable_close == "on") aiosp_disable_close = true;
		if (event == "load" && aiosp_value_load_once_per_visit == "on") aiosp_write_cookie("aiosp_load", aiosp_value_cookie, 0);
		else if (event == "scroll" && aiosp_value_scroll_once_per_visit == "on") aiosp_write_cookie("aiosp_scroll", aiosp_value_cookie, 0);
		if (event == "scroll") aiosp_scroll_lock = true;
		if (delay > 0) {
			aiosp_timeout = setTimeout("aiosp_counter();", 1000);
		}
		aiosp_open();
		return true;
	} else return false;
}

function aiosp_counter() {
	if (aiosp_countdown == 0) {
		clearTimeout(aiosp_timeout);
		aiosp_close();
	} else {
		aiosp_countdown = aiosp_countdown - 1;
		jQuery("#aiosp_delay").html(aiosp_countdown_string(aiosp_countdown));
		aiosp_timeout = setTimeout("aiosp_counter();", 1000);
	}
}

function aiosp_subscribe() {
	var aiosp_name = "";
	if (aiosp_value_disable_name != "on") aiosp_name = jQuery("#aiosp_name").val();
	var aiosp_email = jQuery("#aiosp_email").val();
	var data = {name: aiosp_name, email: aiosp_email, action: "aiosp_submit"};
	jQuery("#aiosp_name").removeClass("aiosp_redborder");
	jQuery("#aiosp_email").removeClass("aiosp_redborder");
	jQuery("#aiosp_submit").attr("disabled", "disabled");
	jQuery("#aiosp_loading").css("display", "inline-block");
	jQuery.ajax({
		url: aiosp_baseurl+"ajax.php", 
		data: data,
		dataType: "jsonp",
		success: function(data) {
			var html_data = data.html;
			jQuery("#aiosp_submit").removeAttr("disabled");
			jQuery("#aiosp_loading").css("display", "none");
			if(html_data.match("ERROR") != null) {
				if(html_data.match("name") != null) jQuery("#aiosp_name").addClass("aiosp_redborder");
				if(html_data.match("email") != null) jQuery("#aiosp_email").addClass("aiosp_redborder");
			} else {
				aiosp_write_cookie("aiosp", aiosp_value_cookie, 180);
				clearTimeout(aiosp_timeout);
				aiosp_countdown = 0;
				aiosp_lock = true;
				aiosp_close();
			}
		}
	});
}